﻿<?LassoScript

	// List of contacts demo for Lasso Summit 2007
	// Author Jolle Carlestam
	// Use and alter freely but please keep this info




	// Preparation of demo content. This should be replaced with your
	// own record content handling.
	// the demo assumes that the files ex_cont/Contacts.incl, 
	// ex_cont/jina_prepPDF_demo.incl,
	// ex_cont/summit07banner.jpg and ex_cont/line.gif
	// are in the same folder and can be accessed by Lasso.
	Include:'ex_cont/jina_prepPDF_demo.incl';
	var:'allData' = jina_prepContacts: (Include:'ex_cont/Contacts.incl');

	// If you only want the first page while testing set this to true.
	var:'firstPageonly' = false;

	//#####################################################################//
	// Settings that control the look and layout of the list pages.
	// These demo settings are suitable for an A4 page.

	// Logo image used in the header of the first page.
	// Real image size should be at least twice the width and height.
	// That is if space on paper width is 273 and height is 173 then
	// image size should be 546 * 346.
	var:'logoImage' = (PDF_Image:
		-file = 'ex_cont/summit07banner.jpg'); // Logo size 1042 * 1042
	var:'logoWidth' = 150;
	var:'logoHeight' = 150;
	Var:'lineImage' = PDF_Image:-File='ex_cont/line.gif';

	// Heading displayed on every page.
	var:'headingText' = 'Lasso Summit 2007 List of Participants';

	// These variables set the font face and leading
	var:'headingFont' = (pdf_font: -face = 'Helvetica-Bold', -size = 14, -color = '#000000');
	var:'nameFont' = (pdf_font: -face = 'Helvetica-Bold', -size = 10, -color = '#e9a45f');
	var:'titleFont' = (pdf_font: -face = 'Helvetica-Oblique', -size = 10, -color = '#000000');
	var:'orgFont' = (pdf_font: -face = 'Helvetica', -size = 10, -color = '#000000');
	var:'infoFont' = (pdf_font: -face = 'Helvetica', -size = 10, -color = '#000000');
	var:'addressFont' = (pdf_font: -face = 'Helvetica', -size = 10, -color = '#000000');
	var:'typeFont' = (pdf_font: -face = 'Helvetica', -size = 9, -color = '#000000');
	var:'footerFont' = (pdf_font: -face = 'Helvetica', -size = 8, -color = '#000000');

	var:'titleLeading' = 16;
	var:'textLeading' = 12;

	var:'pageSize' = 'A4';
	var:'pageHeight' = 842;
	var:'pageWidth' = 595;

	// The top, left and bottom margin for the page, in points.
	var:'marginTop' = 45;
	var:'marginLeft' = 60;
	var:'marginBottom' = 25;
	
	// The left and width of each column.
	var:'col1Left' = 0; //Relative to the page left margin.
	var:'col1Width' = 260;
	
	var:'col2Left' = 80; //Relative to the page left margin.
	var:'col2Width' = 160;
	
	var:'col3Left' = 286; //Relative to the page left margin.
	var:'col3Width' = 220;
	
	// Setting a default country that will not show up in the list. All other countries will.
	var:'defaultCountry' = 'USA';

	//#####################################################################//

	// Vars set to be used by the application. Do not change these.
	var:'listData' = array;
	var:'listItemArray' = array;
	var:'titleContact' = string;
	var:'nameContact' = string;
	var:'orgContact' = string;
	var:'addressContact' = array;
	var:'infoContact' = array;
	var:'itemTemp' = array;
	var:'listItemTemp' = string;
	var:'leftColText' = string;
	var:'addressText' = string;
	var:'typeText' = string;
	var:'rightColText' = string;
	var:'leftVerSize' = integer;
	var:'leftCol2VerSize' = integer;
	var:'rightVerSize' = integer;
	var:'col2RowCount' = integer;
	var:'addressItemTop' = integer;
	var:'itemTop' = $marginTop + $logoHeight + 10;

	
	// Create the PDF file.
	var:'pdfTemplate' = (pdf_doc:
		-nocompress,
		-size = $pageSize,
		-title = 'list',
		-author = 'jinaOnline',
		-margins = (array: 0,0,0,0)
		);

	// Placing the logo on the first page.
	$pdfTemplate->(Add:$logoImage,
		-left = $marginLeft,
		-top = $marginTop + $logoHeight,
		-height = $logoHeight,
		-width = $logoWidth);

	// Placing a headline on top of first page.
	$pdfTemplate->(Add:
		(PDF_Text: $headingText,
			-type = 'paragraph',
			-font = $headingFont),
		-width = $pageWidth - ($marginLeft * 2),
		-left = $marginLeft,
		-top = $itemTop,
		-align = 'center');

	// Finding out how much vertical space the headline text use.
	$listItemArray = $headingText->(split:'\r');

	$leftVerSize = $listItemArray->Size; // This gives us all hardcoded line feeds. There shouldn't be any, but you never know.

	iterate:  $listItemArray, $listItemTemp;
		// This adds rows if the content flows over more than one row.
		$leftVerSize += math_floor(($titleFont->(textwidth: $listItemTemp)) / ($pageWidth - ($marginLeft * 2)));
	/iterate;

	$leftVerSize *= $titleLeading;

	// Set first list item vertical position.
	$itemTop += $leftVerSize + $titleLeading;

	// Iterate all contacts. This would probably be a Records container in the real world
	iterate: $allData, $listData; // $listData now holds all info for one contact in an array.

		$titleContact = (jina_prepTitle: $listData, -forList); // $titleContact holds an eventual title of the contact.
		$nameContact = (jina_prepName: $listData, 'Yes'); // $nameContact holds the name of the contact.
		$orgContact = (jina_prepOrg: $listData, -forList); // $orgContact holds the organisation of the contact.
		$addressContact = (jina_prepAddress: $listData, $defaultCountry); // $addressContact holds all addresses (and eventual Country) of the contact in an array.
		$infoContact = jina_prepInfo: $listData; // $infoContact holds phone, e-mail etc of the contact in an array.


		// Calculate the vertical space within the nametag that this content will occupy. And inserting into PDF text objects.

		// First checking the name.
		$listItemArray = $nameContact->(split:'\r');
		
		$leftVerSize = $listItemArray->Size; // This gives us all hardcoded line feeds. There shouldn't be any, but you never know.

		iterate:  $listItemArray, $listItemTemp;
			// This adds rows if the content flows over more than one row.
			$leftVerSize += math_floor(($nameFont->(textwidth: $listItemTemp)) / $col1Width);
		/iterate;

		// Creating the PDF object.
		$leftColText = (PDF_Text: ($nameContact + '\r'),
			-Type = 'paragraph',
			-Font = $nameFont);
		// Then checking the title.
		if:$titleContact->Size > 0;
			$listItemArray = $titleContact->(split:'\r');

			$leftVerSize += $listItemArray->Size; // This gives us all hardcoded line feeds. There shouldn't be any, but you never know.

			iterate:  $listItemArray, $listItemTemp;
				// This adds rows if the content flows over more than one row .
				$leftVerSize += math_floor(($titleFont->(textwidth: $listItemTemp)) / $col1Width);
			/iterate;

			// Adding to the PDF object.
			$leftColText->(Add: 
				(PDF_Text: $titleContact + '\r',
					-Font = $titleFont));

		/if;

		// Then checking the org
		if:$orgContact->Size > 0;
			$listItemArray = $orgContact->(split:'\r');

			$leftVerSize += $listItemArray->Size; // This gives us all hardcoded line feeds. There shouldn't be any, but you never know.

			iterate:  $listItemArray, $listItemTemp;
				// This adds rows if the content flows over more than one row.
				$leftVerSize += math_floor(($orgFont->(textwidth: $listItemTemp)) / $col1Width);
			/iterate;

			// Adding to the PDF object.
			$leftColText->(Add:
				(PDF_Text: $orgContact + '\r',
					-Font = $orgFont));

		/if;

		// Then checking addresses.
		if:$addressContact->Size > 0;
			// Creating the pdf object holding the address content.
			$addressText = (PDF_Text: '',
				-Type = 'paragraph',
				-Font = $addressFont);
			// Creating the pdf object holding the address type.
			$typeText = (PDF_Text: '',
				-Type = 'paragraph',
				-Font = $typeFont);

			// setting starting point for addresses.
			$addressItemTop = $leftVerSize * $textLeading;

			// There can be several addresses. Iterate to handle each one.
			iterate:$addressContact, $itemTemp;
				$listItemArray = $itemTemp->Value->(split:'\r');
				$col2RowCount = $listItemArray->Size; // This gives us all hardcoded line feeds.

				iterate:  $listItemArray, $listItemTemp;
					// This adds rows if the content flows over more than one row.
					$col2RowCount += math_floor(($addressFont->(textwidth: $listItemTemp)) / $col2Width);
				/iterate;

				$leftVerSize += $col2RowCount;

			// Adding to the PDF object.
				$typeText->(Add:
					(PDF_Text: $itemTemp->Name,
						-Font = $typeFont));

				// Add rows so that next display of address type is vertically aligned with next address.
				loop: $col2RowCount;
					$typeText->(Add:
						(PDF_Text: '\r'));
				/loop;

				$addressText->(Add:
					(PDF_Text: $itemTemp->Value + '\r',
						-Font = $addressFont));


			/iterate;

		/if;

		$leftVerSize *= $textLeading;

		// And finally checking infos.
		if:$infoContact->Size > 0;
			// Creating the PDF object.
			$rightColText = (PDF_Text: '',
				-Type = 'paragraph',
				-Font = $infoFont);

			$rightVerSize = integer;
			iterate:$infoContact, $itemTemp;
				$listItemArray = $itemTemp->Value->(split:'\r');
				$rightVerSize += $listItemArray->Size; // This gives us all hardcoded line feeds.

				iterate:  $listItemArray, $listItemTemp;
					// This adds rows if the content flows over more than one row.
					$rightVerSize += math_floor(($infoFont->(textwidth: $listItemTemp)) / $col3Width);
				/iterate;
				$rightColText->(Add:
					(PDF_Text: $itemTemp->Value + (($itemTemp->Name != 'E-mail' && $itemTemp->Name != 'Web' && $itemTemp->Name->Size > 0) ? (' (' + $itemTemp->Name + ') ')) + '\r',
						-Font = $infoFont));

			/iterate;

		/if;

		$rightVerSize *= $textLeading;

		// Get vertical space from column that's largest.
		$leftVerSize = (Math_Max:$leftVerSize, $rightVerSize);

		// Checking if there's room on the page for this item. If not a new page is added.
		if:$leftVerSize + $itemTop > $pageHeight - $marginBottom;
			// Add a footer to the present page first.
			$pdfTemplate->(Add:
				(PDF_Text: ($headingText + ' -- Created: ' + date + ' -- Page: ' + $pdfTemplate->GetPageNumber),
					-type = 'paragraph',
					-font = $footerFont),
				-width = $pageWidth - ($marginLeft * 2),
				-left = $marginLeft,
				-top = $pageHeight - ($marginBottom * 1.5),
				-align = 'right');

			(($firstPageonly) ? loop_abort);

			$pdfTemplate->AddPage;

			// Reset the top position for next item.
			$itemTop = $marginTop;
		/if; 


		// Time to add this item content to the pdf.
		$pdfTemplate->(Add: $leftColText,
			-width = $col1Width,
			-left = $marginLeft + $col1Left,
			-top = $itemTop,
			-align = 'left', 
			-leading = $textLeading);

		$pdfTemplate->(Add: $addressText,
			-width = $col1Width,
			-left = $marginLeft + $col2Left,
			-top = $itemTop + $addressItemTop,
			-align = 'left', 
			-leading = $textLeading);

		$pdfTemplate->(Add: $typeText,
			-width = $col2Left - 6,
			-left = $marginLeft,
			-top = $itemTop + $addressItemTop,
			-align = 'right', 
			-leading = $textLeading);

		$pdfTemplate->(Add: $rightColText,
			-width = $col3Width,
			-left = $marginLeft + $col3Left,
			-top = $itemTop,
			-align = 'left', 
			-leading = $textLeading);

		$itemTop += $leftVerSize + 7;

		$pdfTemplate->(Add:$lineImage, -left = $marginLeft + 5, -top = $itemTop - 2 , -height = 0.5, -width = 400);


	/iterate;

// Serve the PDF.
	$pdfTemplate->close;
	pdf_serve: -content = $pdfTemplate, -file = 'Jina Demo Contact List.pdf';
error_currentError;

?>